function [out] = display_v_proj(v,u,unitDeg)
% out: the isotropy map in Section 3.1
% v: weights in RNLTV
% u: image
% unitDeg: rotated angle in Fig. 3
%
if (nargin < 3)
    unitDeg = 1;
end
size_in=size(u);
sizeB=sqrt( size(v,2)+1 );
radius = floor(sizeB/2);

numCoord = floor(90/unitDeg); % 6

xx = []; yy = [];
for index = 1:size(v,2)+1
    tx = floor((index-1)/sizeB);
    ty = index-1 - tx*sizeB - radius;
    tx = (tx-radius);
    tx = -tx;
    
    temp = tx;
    tx = ty; ty = temp;
    
    if tx~=0 | ty~=0
        xx = [xx,tx];
        yy = [yy,ty];
    end
end

% 4: i+, i-, j+, j-
direct = zeros(size_in(1),size_in(2),numCoord,4);
for r_u = 1:size_in(1)
    for c_u = 1:size_in(2)
        % Column-major
        r_v = r_u+ (c_u-1)*size_in(1);
        
        for k = 1:numCoord
            ang = (k-1)*unitDeg;
            sin_ang = sin(ang/180*pi);
            cos_ang = cos(ang/180*pi);
            
            % i:( sin(ang), cos(ang) )
            tmp_i = v(r_v,:).*(sin_ang.*xx + cos_ang.*yy);
            % j:( cos(ang), -sin(ang) )
            tmp_j = v(r_v,:).*(cos_ang.*xx - sin_ang.*yy);
            
            % i+
            direct(r_u,c_u,k,1) = sum(tmp_i(tmp_i>0));
            % i-
            direct(r_u,c_u,k,2) = sum(tmp_i(tmp_i<0));
            
            % j+
            direct(r_u,c_u,k,3) = sum(tmp_j(tmp_j>0));
            % j-
            direct(r_u,c_u,k,4) = sum(tmp_j(tmp_j<0));
        end
        
    end
end

direct = abs(direct);

sum_abs_i = sum(abs(direct(:,:,:,1:2)),4);
sum_abs_j = sum(abs(direct(:,:,:,3:4)),4);

ratio = max(sum_abs_i./sum_abs_j,sum_abs_j./sum_abs_i);
[max_ratio,max_ind] = max(ratio,[],3);
out = log(max_ratio);

% get rid of Inf
ind = out==Inf;
out(out==Inf)=max(out(~ind));
end